def materials_from_file
  mod = Sketchup.active_model
  textures_from_file = []
  images = []
  image_path ||= File.dirname(__FILE__) + "/*.*"
  image_path = UI.openpanel("Texture Files", image_path)
  unless image_path.nil?
    image_folder = File.dirname(image_path.gsub('\\', '/'))
    images = Dir[image_folder + "/*.{jpg,png,tif,bmp,gif,tga,epx}"]
    images.each { |i| textures_from_file << File.basename(i, '.*') }
    if textures_from_file[0]
      textures_from_file.each_with_index do |name, i|
        unless mod.materials[name]
          mat = mod.materials.add(name)
          mat.texture = images[i]
          mat.texture.size = [1500.mm, 1500.mm]
          mat.save_as("D:\\" + mat.name + ".skm")
        end
      end
    end
  end
end

# Đăng ký lệnh vào menu Extensions
UI.menu("Extensions").add_item("Materials from File") {
  materials_from_file
}
